--------------------------------------------------------------------
--            SymCACP Script Module Find End Validate
-- Symmetrical CA Control Panel   symCACPscript-1
--file for finding end generation (script2 version)
-- This version just checks a file of data
--------------------------------------------------------------------
--  P. Rendell  19/08/2020
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-findEnd"
local m={}			-- class table
m.cnt = 0
m.outPut = false
m.noLines = 0
m.noDiffs = 0
m.noMaxEx = 0

local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search") 
m.colonList = {}
m.equalList = {['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',"R"}, ['RESULTS_NEW'] = {'t',""},
               ['STEP1'] = {"d","R"}, ['MAX_OSC'] = {"d","R"}, ['MIN_OSC'] = {"d","R"},
               ['MAX_GEN'] = {'d',"R"},
               ['CHECK_MAX_GEN'] = {'l',"R"} }

------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   return true
end



--==============================================================================

   local function doFINDpopRes(outFile, rule, geo, wv, hv, seed, gen, oscPeriod, pop, res)
      if m.outPut then
         outFile:write(string.format("%s, %s, %4s, %4s, %8s, %8s, %8s, %4i, %s\n",
                                rule, geo:sub(1,2), wv, hv, seed, gen, oscPeriod, pop, res))
      end
   end
--------------------------------------------------------------------------------
   function saveResults(typeOR)
      --   key = rule..':'..geo:sub(1,2)..':'..tostring(hv)..':'..tostring(wv)..':'..seed
      --   m.linesDone[key] = {gen, period, type}
      m.cnt = m.cnt + 1
      logFile:write("saveResults call "..m.cnt..'\n')
      local a = false; for k in pairs(m.linesDone) do a = true; break end  -- test that m.linesDone is not empty
      if m.outPut  and a and ((scriptFileData.SAVE_OTHER) or (typeOR == "override") ) then
         local keyPart
         for key in pairs(m.linesDone) do
            keyPart = {}
            for word in string.gmatch(key, "[^:]+") do
               keyPart[#keyPart + 1] = word
            end
            if ((#keyPart == 5) and (#m.linesDone[key] == 4)) then
                 doFINDpopRes(m.outFile, keyPart[1], keyPart[2], keyPart[3], keyPart[4], keyPart[5], m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3], m.linesDone[key][4])
                 m.linesDone[key] = nil
            else
               logFile:write("** saveResults: either key "..key.." does not have 5 parts or linesDone[key] "..#m.linesDone[key].." does not have 4 parts\n")
            end
         end
         m.outFile:close(); m.outFile = nil
      end
   end

--------------------------------------------------------------------------------
   
   function openOutFile()
      local res = false
      local words = {}
      local key
      local inFile
      local test = true
      m.linesDone = {}
      m.outPut = false
      logFile:write(' openOutFile\n')
      if scriptFileData then
         inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
         if inFile then
            m.outFile = nil
            if scriptFileData.RESULTS_NEW then
               m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
               if m.outFile then
                  m.outPut = true
               end
            end
            local line = inFile:read("*l")
            logFile:write('openOutFile start reading\n')
            while line do
               words = split(line)
               if #words == 9 then
                  key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                  if  (m.linesDone[key]) and (words[9] == 'maxEx') then
                     if (m.linesDone[key][4] ~= 'end') and 
                         ( 
                            (tonumber(words[6]) > tonumber(m.linesDone[key][1])) or
                            (tonumber(words[7]) < tonumber(m.linesDone[key][2])) or 			-- for maxEx period is negative
                            (tonumber(words[7]) > 0 )  			-- for maxEx period is negative
                          ) 
                     then
                         logFile:write(openOutFile 'm.linesDone changed '..m.linesDone[key][1]..'->'..words[6]..' \n')
                         m.linesDone[key] = {words[6],words[7],words[8],words[9]}
                     end
                  else
                     m.linesDone[key] = {words[6],words[7],words[8],words[9]}	-- gen, period, pop, type
                     m.noLines = m.noLines + 1
                  end
               else
                  logFile:write('openOutFile line '..line..' not 9 words\n')
               end
               line = inFile:read("*l")
            end 
            logFile:write('openOutFile m.linesDone collected '..m.noLines..'\n')
            res = true
            if not m.outFile then

               m.outPut = false
               if (scriptFileData.RESULTS_NEW) then 
                  logFile:write("openOutFile Output file not open"..scriptFileData.RESULTS_NEW.."\n")
               else
                  logFile:write("openOutFile no Output file\n")
                  res = true
               end
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile Input file not open infile:"..scriptFileData.RESULTS_OLD.."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no script file data\n")
         res = false
      end
      return (res)
   end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)
--------------------------------------------------------------------------
   logFile:write('\ndoFINDEND-n\n')
   local test =true
   local logDiverted
   local startTime = os.clock()
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if openOutFile(m,scriptFileData) then
         local rule, seed, geo, hv, wv
         for key in pairs(m.linesDone) do
            keyPart = {}
            for word in string.gmatch(key, "[^:]+") do
               keyPart[#keyPart + 1] = word
            end
            if (#keyPart == 5) then
               rule = keyPart[1]
               geo = keyPart[2]
               wv =  tonumber(keyPart[3])
               hv = tonumber(keyPart[4])
               seed = keyPart[5]    

--               logFile:write("OldData key "..key..'\n')
               logFile:write("OldData "..m.linesDone[key][1]..","..m.linesDone[key][2]..","..m.linesDone[key][3]..","..m.linesDone[key][4]..'\n')
               maxOsc = tonumber(m.linesDone[key][2])+10
               minOsc = 1
               step1 = math.max( 0,math.min( tonumber(m.linesDone[key][1]),scriptFileData.MAX_GEN)  )
               logFile:write("Step1 ",step1,"; end type "..m.linesDone[key][4]..'\n')

               gr.doBuild(' SymCACP findEndVal ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
               g.run(math.floor(math.max(step1*0.99,5)))
               res = gs.doFindEnd(seed, scriptFileData.MAX_GEN, math.floor(math.max(step1*0.05,3)), minOsc, maxOsc)
               if (res ~= 'killed') then
                  g.show(res..' seed '..seed..' gen '..tonumber(g.getgen()))
--                     m.linesDone[key] = {words[6],words[7],words[8],words[9]}	-- gen, period, pop, type
                  if (tonumber(m.linesDone[key][1]) ~= tonumber(g.getgen()) or
                      tonumber(m.linesDone[key][2]) ~= gs.oscPeriod or
                      tonumber(m.linesDone[key][3]) ~= gs.pop or
                      m.linesDone[key][4] ~= res ) then
                     m.noDiffs = m.noDiffs + 1
                     g.show ("Difference found rule "..rule.." w "..wv.." seed "..seed.." res "..res.." gen "..tonumber(g.getgen()))
                     logFile:write("Difference found rule "..rule.." w "..wv.." seed "..seed.." res "..res.." gen "..tonumber(g.getgen())..'\n')
                     if (tonumber(m.linesDone[key][1]) ~= tonumber(g.getgen())) then
                        logFile:write("dif 1 "..m.linesDone[key][1].." : "..tonumber(g.getgen()).."\n")
                     end
                     if (m.linesDone[key][2] ~= gs.oscPeriod) then
                        logFile:write("dif 2\n")
                     end
                     if (m.linesDone[key][3] ~= gs.pop) then
                        logFile:write("dif 3\n")
                     end
                     if (m.linesDone[key][4] ~= res) then
                        logFile:write("dif 4\n")
                     end
                  end
                  if ( res == "maxEx") then 
                     doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), -maxOsc, gs.pop,res)
                     m.noMaxEx = m.noMaxEx + 1
                  else
                     doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), gs.oscPeriod, gs.pop,res)
                  end
               end

            else
               logFile:write("Short Key in data"..key.."\n")
            end            
            if res == 'killed' then break end
         end
         if m.outFile then
            m.outFile:close()
            m.outFile = nil
         end
         logFile:write("Total Line "..m.noLines.." Differance found "..m.noDiffs.." No Max Exceeded "..m.noMaxEx.."\n")
         comProcs.showTextOV("Total Line "..m.noLines.." Differance found "..m.noDiffs.." No Max Exceeded "..m.noMaxEx)
      else
        comProcs.showTextOV('Data not loaded')
        logFile:write('Data not loaded\n')
      end
      g.show('Finished')
   else
     comProcs.showTextOV('No Script file Loaded')
     logFile:write('No Script file Loaded\n')
   end
   local elapsed = os.clock()-startTime
   local elHrs = math.floor(elapsed/3600)
   local elMins = math.floor((elapsed-elHrs*3600)/60)
   local elSecs = (elapsed-elHrs*3600-elMins*60)   
   logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
end

return m
------------------------------------------------------------
